<?php
// If it's going to need the database, then it's 
// probably smart to require it before we start.
require_once('config.php');
require_once('database.php');
require_once('session.php');


class Screen extends DatabaseObject {
	
	protected static $table_name="screen";
	protected static $db_fields = array('id', 'property_code', 'property_name', 'scr_no', 'show_no', 'bmp_time', 'interval_time', 'status');
	
	public $id;
	public $property_code;
	public $property_name;
	public $scr_no;
	public $show_no;
	public $bmp_time;
	public $interval_time;
	public $status;

	
	
	// Common Database Methods
	public static function find_all() {
		return self::find_by_sql("SELECT * FROM ".self::$table_name." order by id DESC");
  	}
	  
	public static function find_by_id($id=0) {
		$result_array = self::find_by_sql("SELECT * FROM ".self::$table_name." WHERE id={$id} LIMIT 1");
		return !empty($result_array) ? array_shift($result_array) : false;
	}
	
	public static function find_by_employee_id($emp_code) {
		$result_array = self::find_by_sql("SELECT * FROM ".self::$table_name." WHERE employee_id='{$emp_code}' LIMIT 1");
		return !empty($result_array) ? array_shift($result_array) : false;
	}

	public static function find_by_last_id() {
		$result_array = self::find_by_sql("SELECT * FROM ".self::$table_name." Order by id DESC LIMIT 1");
		return !empty($result_array) ? array_shift($result_array) : false;
	}
	
	
	
  	
	public static function find_by_cust_id($id) {
		return self::find_by_sql("SELECT * FROM ".self::$table_name." WHERE customer_id='{$id}'");
  	}
	
	
	public static function find_by_sql($sql="") {
		global $database;
		$result_set = $database->query($sql);
		$object_array = array();
		while ($row = $database->fetch_array($result_set)) {
		  $object_array[] = self::instantiate($row);
		}
		return $object_array;
	}


	public static function authenticate($username="", $password="") {
		global $database;
		$username = $database->escape_value($username);
		$password = $database->escape_value($password);
	
		$sql  = "SELECT * FROM ".self::$table_name;
		$sql .= " WHERE employee_code = '{$username}' ";
		$sql .= "AND password = '{$password}' ";
		$sql .= "LIMIT 1";
		$result_array = self::find_by_sql($sql);
		return !empty($result_array) ? array_shift($result_array) : false;
	}
	
	public static function authenticate_mobile($mobile) {
		$result_array = self::find_by_sql("SELECT * FROM ".self::$table_name." WHERE mobile='{$mobile}' LIMIT 1");
		return !empty($result_array) ? array_shift($result_array) : false;
	}

	public static function authenticate_emp_email($email) {
		$result_array = self::find_by_sql("SELECT * FROM ".self::$table_name." WHERE email='{$email}' LIMIT 1");
		return !empty($result_array) ? array_shift($result_array) : false;
	}

	public static function find_by_emp_name($emp_name) {
		$result_array = self::find_by_sql("SELECT * FROM ".self::$table_name." WHERE name='{$emp_name}' LIMIT 1");
		return !empty($result_array) ? array_shift($result_array) : false;
	}

	public static function find_by_emp_code($emp_code) {
		$result_array = self::find_by_sql("SELECT * FROM ".self::$table_name." WHERE employee_id='{$emp_code}' LIMIT 1");
		return !empty($result_array) ? array_shift($result_array) : false;
	}
  	
	public static function count_all() {
		global $database;
		$sql = "SELECT COUNT(*) FROM ".self::$table_name." ";
		$result_set = $database->query($sql);
		$row = $database->fetch_array($result_set);
		return array_shift($row);
	}
		
	public static function count_status($status) {
		global $database;
		$sql = "SELECT COUNT(*) FROM ".self::$table_name." WHERE status = '".$status."'";
		$result_set = $database->query($sql);
		$row = $database->fetch_array($result_set);
		return array_shift($row);
	}
	
	
		
	
	
//  ---- Code For Employee Start -------------------------------------------------------------------------------
	
	public static function count_emp_doc_approval($doc_approval) {
	  global $database;
	  $sql = "SELECT COUNT(*) FROM ".self::$table_name." WHERE doc_approval = '{$doc_approval}' AND status = 1 ";
      $result_set = $database->query($sql);
	  $row = $database->fetch_array($result_set);
    return array_shift($row);
	}

	public static function count_attendance_designation($designation) {
	  global $database;
	  $sql = "SELECT COUNT(*) FROM ".self::$table_name." Where designation = '{$designation}' AND status = 1";
    $result_set = $database->query($sql);
	  $row = $database->fetch_array($result_set);
    return array_shift($row);
	}
	
	public static function count_by_customer_id_emp($id, $emp_id) {
	  global $database;
	  $sql = "SELECT COUNT(*) FROM ".self::$table_name." Where emp_id = '{$emp_id}' AND customer_id = '{$id}' ";
    $result_set = $database->query($sql);
	  $row = $database->fetch_array($result_set);
    return array_shift($row);
	}
	
	public static function count_all_emp($status) {
	  global $database;
	  $sql = "SELECT COUNT(*) FROM ".self::$table_name." Where status = '{$status}' ";
      $result_set = $database->query($sql);
	  $row = $database->fetch_array($result_set);
    return array_shift($row);
	}
	
	public static function count_status_emp($status,$emp_id) {
	  global $database;
	  $sql = "SELECT COUNT(*) FROM ".self::$table_name." WHERE emp_id = '{$emp_id}' AND status = '".$status."'";
      $result_set = $database->query($sql);
	  $row = $database->fetch_array($result_set);
    return array_shift($row);
	}
	
	public static function count_emp_status_emp($status,$emp_id) {
	  global $database;
	  $sql = "SELECT COUNT(*) FROM ".self::$table_name." WHERE emp_id = '{$emp_id}' AND emp_status = '".$status."'";
      $result_set = $database->query($sql);
	  $row = $database->fetch_array($result_set);
    return array_shift($row);
	}
	
	public static function count_cust_status_emp($status,$emp_id) {
	  global $database;
	  $sql = "SELECT COUNT(*) FROM ".self::$table_name." WHERE emp_id = '{$emp_id}' AND cust_status = '".$status."'";
      $result_set = $database->query($sql);
	  $row = $database->fetch_array($result_set);
    return array_shift($row);
	}
	
	public static function count_business_vertical_emp($status,$emp_id) {
	  global $database;
	  $sql = "SELECT COUNT(*) FROM ".self::$table_name." WHERE emp_id = '{$emp_id}' AND business_vertical = '".$status."'";
      $result_set = $database->query($sql);
	  $row = $database->fetch_array($result_set);
    return array_shift($row);
	}
	
	public static function count_identify_source_emp($source,$emp_id) {
	  global $database;
	  $sql = "SELECT COUNT(*) FROM ".self::$table_name." WHERE emp_id = '{$emp_id}' AND identify_source = '".$source."'";
      $result_set = $database->query($sql);
	  $row = $database->fetch_array($result_set);
      return array_shift($row);
	}
	
//  ---- Code For Employee End -------------------------------------------------------------------------------

	

//  ---- Code For Customer Start -------------------------------------------------------------------------------
	
	public static function count_all_cust($cust_id) {
	  global $database;
	  $sql = "SELECT COUNT(*) FROM ".self::$table_name." Where customer_id = '{$cust_id}' ";
      $result_set = $database->query($sql);
	  $row = $database->fetch_array($result_set);
    return array_shift($row);
	}
	
	public static function count_status_cust($status,$cust_id) {
	  global $database;
	  $sql = "SELECT COUNT(*) FROM ".self::$table_name." WHERE customer_id = '{$cust_id}' AND status = '".$status."'";
      $result_set = $database->query($sql);
	  $row = $database->fetch_array($result_set);
    return array_shift($row);
	}
	
	public static function count_emp_status_cust($status,$cust_id) {
	  global $database;
	  $sql = "SELECT COUNT(*) FROM ".self::$table_name." WHERE customer_id = '{$cust_id}' AND emp_status = '".$status."'";
      $result_set = $database->query($sql);
	  $row = $database->fetch_array($result_set);
    return array_shift($row);
	}
	
	public static function count_cust_status_cust($status,$cust_id) {
		global $database;
		$sql = "SELECT COUNT(*) FROM ".self::$table_name." WHERE customer_id = '{$cust_id}' AND cust_status = '".$status."'";
		$result_set = $database->query($sql);
		$row = $database->fetch_array($result_set);
		return array_shift($row);
	}
	
	public static function count_business_vertical_cust($status,$cust_id) {
	  global $database;
	  $sql = "SELECT COUNT(*) FROM ".self::$table_name." WHERE customer_id = '{$cust_id}' AND business_vertical = '".$status."'";
      $result_set = $database->query($sql);
	  $row = $database->fetch_array($result_set);
    return array_shift($row);
	}
	
	public static function count_identify_source_cust($source,$cust_id) {
	  global $database;
	  $sql = "SELECT COUNT(*) FROM ".self::$table_name." WHERE customer_id = '{$cust_id}' AND identify_source = '".$source."'";
      $result_set = $database->query($sql);
	  $row = $database->fetch_array($result_set);
      return array_shift($row);
	}
	
//  ---- Code For Customer End -------------------------------------------------------------------------------
	
	
	
	private static function instantiate($record) {
		// Could check that $record exists and is an array
    $object = new self;
		// Simple, long-form approach:
		// $object->id 				= $record['id'];
		// $object->username 	= $record['username'];
		// $object->password 	= $record['password'];
		// $object->first_name = $record['first_name'];
		// $object->last_name 	= $record['last_name'];
		
		// More dynamic, short-form approach:
		foreach($record as $attribute=>$value){
		  if($object->has_attribute($attribute)) {
		    $object->$attribute = $value;
		  }
		}
		return $object;
	}
	
	private function has_attribute($attribute) {
	  // We don't care about the value, we just want to know if the key exists
	  // Will return true or false
	  return array_key_exists($attribute, $this->attributes());
	}

	protected function attributes() { 
		// return an array of attribute names and their values
	  $attributes = array();
	  foreach(self::$db_fields as $field) {
	    if(property_exists($this, $field)) {
	      $attributes[$field] = $this->$field;
	    }
	  }
	  return $attributes;
	}
	
	protected function sanitized_attributes() {
	  global $database;
	  $clean_attributes = array();
	  // sanitize the values before submitting
	  // Note: does not alter the actual value of each attribute
	  foreach($this->attributes() as $key => $value){
	    $clean_attributes[$key] = $database->escape_value($value);
	  }
	  return $clean_attributes;
	}
	
	public function save() {
	  // A new record won't have an id yet.
	  return isset($this->id) ? $this->update() : $this->create();
	}
	
	public function create() {
		global $database;
		// Don't forget your SQL syntax and good habits:
		// - INSERT INTO table (key, key) VALUES ('value', 'value')
		// - single-quotes around all values
		// - escape all values to prevent SQL injection
		$attributes = $this->sanitized_attributes();
	  $sql = "INSERT INTO ".self::$table_name." (";
		$sql .= join(", ", array_keys($attributes));
	  $sql .= ") VALUES ('";
		$sql .= join("', '", array_values($attributes));
		$sql .= "')";
	  if($database->query($sql)) {
	    $this->id = $database->insert_id();
	    return true;
	  } else {
	    return false;
	  }
	}

	public function update() {
	  global $database;
		// Don't forget your SQL syntax and good habits:
		// - UPDATE table SET key='value', key='value' WHERE condition
		// - single-quotes around all values
		// - escape all values to prevent SQL injection
		$attributes = $this->sanitized_attributes();
		$attribute_pairs = array();
		foreach($attributes as $key => $value) {
		  $attribute_pairs[] = "{$key}='{$value}'";
		}
		$sql = "UPDATE ".self::$table_name." SET ";
		$sql .= join(", ", $attribute_pairs);
		$sql .= " WHERE id=". $database->escape_value($this->id);
	  $database->query($sql);
	  return ($database->affected_rows() == 1) ? true : false;
	}

	public function delete() {
		global $database;
		// Don't forget your SQL syntax and good habits:
		// - DELETE FROM table WHERE condition LIMIT 1
		// - escape all values to prevent SQL injection
		// - use LIMIT 1
	  $sql = "DELETE FROM ".self::$table_name." ";
	  $sql .= " WHERE id=". $database->escape_value($this->id);
	  $sql .= " LIMIT 1";
	  $database->query($sql);
	  return ($database->affected_rows() == 1) ? true : false;
	
		// NB: After deleting, the instance of User still 
		// exists, even though the database entry does not.
		// This can be useful, as in:
		//   echo $user->first_name . " was deleted";
		// but, for example, we can't call $user->update() 
		// after calling $user->delete().
	}

}

?>