<?php
	header('Access-Control-Allow-Origin: *');
	header('Access-Control-Allow-Methods: POST,GET,OPTIONS');
	header('Access-Control-Allow-Headers: Origin, X-Requested-With, Content-Type, Accept');
	header("Content-Type: application/json; charset=UTF-8");
	
	error_reporting(E_ALL);
    ini_set('display_errors', 1);

	require_once("includes/initialize.php");
	date_default_timezone_set('Asia/Calcutta');
	
	// Remember to give your form's submit tag a name="submit" attribute!
	
	global $database;
	
	$user_id 		= $_GET['uid'];
	$category 	    = $_GET['cat'];	
	$score 	        = $_GET['score'];	

	if(empty($user_id)){
		echo json_encode("User ID Empty");
		return false;
	}
	
	if(empty($category)){
		echo json_encode("Category Empty");
		return false;
	}
	
	if(empty($score)){
		echo json_encode("Score Empty");
		return false;
	}
	
	if($category == "all-rounder"){
	    $category = "All Rounder";
	}
	
	if($category == "haayanaa"){
	    $category = "Haa Ya Naa";
	}
	
	if($category == "mcu"){
	    $category = "Marvel Cinematic Universe";
	}
	
	
	$user = Users::find_by_id($user_id);

	// Check database to see if username/password exist.
    $player_high_score = PlayerScore::auth_high_score($user_id, $category);
    
    if($player_high_score){
        if($score > $player_high_score->score){
            $player_high_score->score       = $score;
        }
    }else {
        $player_high_score = new PlayerScore();
        $player_high_score->score       = $score;
    }
    
    $player_high_score->user_id     = $user_id;
    $player_high_score->user_name   = $user->user_name;
    $player_high_score->category    = $category;
    $player_high_score->date_       = date("Y-m-d");
    $player_high_score->time_       = date("H:i:s");
		
	if ($player_high_score->save()) {
		echo json_encode("Score Updated");
	} else {
	// username/password combo was not found in the database
		echo json_encode('No');
	//echo $data->;
	}
	
?>

